/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define('advanced:views/workflow/conditions/link-parent', ['advanced:views/workflow/conditions/base'], function (Dep) {

    return Dep.extend({

        template: 'advanced:workflow/conditions/base',

        defaultConditionData: {
            comparison: 'notEmpty',
        },

        comparisonList: [
            'notEmpty',
            'isEmpty',
            'equals',
            'notEquals',
            'changed',
            'notChanged',
        ],

        data: function () {
            return _.extend({
            }, Dep.prototype.data.call(this));
        },

        fetch: function () {
            delete this.conditionData.fieldValueMap;
            delete this.conditionData.valueName;
            delete this.conditionData.valueType;

            return Dep.prototype.fetch.call(this);
        },

        getSubjectInputViewName: function (subjectType) {
            return 'advanced:views/workflow/condition-fields/subjects/link-parent';
        },

        handleSubjectType: function (subjectType, noFetch) {
            if (!noFetch) {
                this.clearView('subject');
            }

            if (subjectType === 'typeOf') {
                this.createView('subject', 'advanced:views/workflow/condition-fields/subjects/link-parent-is-type-of', {
                    selector: '.subject',
                    entityType: this.entityType,
                    field: this.field,
                    value: this.getSubjectValue(),
                    conditionData: this.conditionData,
                    readOnly: this.readOnly,
                }, (view) => {
                    view.render(() => {
                        if (!noFetch) {
                            this.fetch();
                        }
                    });
                });

                return;
            }

            Dep.prototype.handleSubjectType.call(this, subjectType, noFetch);
        },

        handleComparison: function (comparison, noFetch) {
            if (!noFetch) {
                this.clearView('subjectType');
            }

            if (comparison === 'equals' || comparison === 'notEquals') {
                this.$el.find('.subject').empty();

                this.createView('subjectType', 'advanced:views/workflow/condition-fields/subject-type-parent', {
                    selector: '.subject-type',
                    value: this.conditionData.subjectType,
                    readOnly: this.readOnly
                }, (view) => {
                    view.render().then(() => {
                        if (!noFetch) {
                            this.fetch();
                        }

                        this.handleSubjectType(this.conditionData.subjectType, noFetch);
                    });

                    this.listenTo(view, 'change', value => {
                        this.setSubjectType(value);
                        this.handleSubjectType(value);
                    });
                });

                return;
            }

            Dep.prototype.handleComparison.call(this, comparison, noFetch);
        },
    });
});
