define('ebla-link-pro:views/field-manager/link-multiple-form/footer-sum-fields-map', ['views/admin/field-manager/fields/options', 'views/fields/array'], function (Dep, Array) {
    return Dep.extend({

        afterRender: function () {
            Array.prototype.afterRender.call(this);

            this.calculateFields();
        },

        calculateFields: function () {
            const footerSumFields = this.model.get('footerSumFields') || [];
            if (footerSumFields.length) {
                this.getParentView().showField(this.name);
            } else {
                this.getParentView().hideField(this.name);
                return;
            }

            const oldValues = Espo.utils.clone(this.model.get(this.name) || {});

            this.model.set(this.name, footerSumFields);

            footerSumFields.forEach(field => {
                this.addValue(field);
            });

            for (const field in oldValues.footerSumFieldsMap) {
                if (!footerSumFields.includes(field)) {
                    this.removeValue(field);
                }
            }
        },

        setup: function () {
            Array.prototype.setup.call(this);

            this.allowCustomOptions = false;
            this.model.on('change:footerSumFields', () => {
                this.calculateFields();
            });
        },

        getItemHtml: function (value) {
            const link = this.model.get('name');
            const scope = this.getMetadata().get(['entityDefs', this.options.scope, 'links', link, 'entity']);

            return `<div class="list-group-item link-with-role form-inline" data-value="${value}">
                            <div class="pull-left item-content" style="width: 92%; display: inline-block;">
                            <select class="role form-control input-sm pull-right" data-name="footerSumFieldsMap" data-value="${value}">
                                ${this.getFieldOptions(value)}
                            </select>
                                <div class="item-text">${this.translate(value, 'fields', scope)}</div>
                            </div>
                            <div style="width: 8%; display: inline-block; vertical-align: top;"></div>
                            <br style="clear: both;" />
                        </div>`;
        },

        getFieldOptions: function (field) {
            const link = this.model.get('name');
            const scope = this.model.scope;
            const footerSumFieldsMap = this.getMetadata().get(['entityDefs', scope, 'fields', link, this.name]) || {};
            this.translatedOptions = {};
            let optionsHtml = '';

            let fields = this.getMetadata().get(['entityDefs', scope, 'fields']) || {};
            let options = Object.keys(Espo.Utils.clone(fields)).filter((item) => {
                const valid = !(
                    fields[item]['notStorable'] ||
                    fields[item]['layoutListDisabled'] ||
                    fields[item]['layoutDetailDisabled']
                );
                return valid && ['int', 'float', 'currency'].includes(fields[item]['type']);

            });

            options.unshift('');
            options.forEach(item => {
                this.translatedOptions[item] = this.translate(item, 'fields', scope);
            });

            (options || []).forEach(option => {
                if (footerSumFieldsMap[field] === option) {
                    optionsHtml += `<option value="${option}" selected>${this.translatedOptions[option]}</option>`;
                } else {
                    optionsHtml += `<option value="${option}">${this.translatedOptions[option]}</option>`;
                }
            });
            return optionsHtml;
        },

        fetch: function () {
            const data = Dep.prototype.fetch.call(this);

            let footerSumFieldsMap = {};
            (data.footerSumFieldsMap || []).forEach(value => {
                let selectedType = this.$el.find('select[data-name="footerSumFieldsMap"][data-value="' + value + '"]').val();
                if (selectedType) {
                    footerSumFieldsMap[value] = selectedType.toString();
                }
            });
            data.footerSumFieldsMap = footerSumFieldsMap;

            return data;
        },
    });
});
