/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/field-manager/link-multiple-form/layout', 'views/fields/enum', function (Dep) {

    return Dep.extend({

        getCustomLayoutName: function () {
            let customLayoutName = 'inlineListFor' + Espo.Utils.upperCaseFirst(this.model.scope);

            if (this.name === 'editLayout') {
                customLayoutName = 'edit' + Espo.Utils.upperCaseFirst(customLayoutName);
            }

            return customLayoutName;
        },

        setupOptions: function () {
            const link = this.model.get('name');
            const scope = this.getMetadata().get(['entityDefs', this.options.scope, 'links', link, 'entity']);
            const additionalLayouts = this.getMetadata().get(['clientDefs', scope, 'additionalLayouts']) || [];
            const customLayoutName = this.getCustomLayoutName();
            let customLayoutExists = false;

            const options = ['listSmall', 'list'];

            // if the custom layout not created before, allow to create it
            for (const additionalLayoutName in additionalLayouts) {
                if (additionalLayoutName === customLayoutName) {
                    customLayoutExists = true;
                }

                if (additionalLayouts[additionalLayoutName].type.startsWith('list')) {
                    options.push(additionalLayoutName);
                }
            }

            if (this.name === 'editLayout') {
                options.unshift('sameAsViewMode');
            }

            this.params.options = options;
            this.translatedOptions = this.translatedOptions || {};

            for (const option of options) {
                if (this.translatedOptions[option]) {
                    continue;
                }

                // translate the option be replace the first letter with upper case and camel case to spaces
                this.translatedOptions[option] = Espo.Utils.upperCaseFirst(option).replace(/([A-Z])/g, ' $1').trim();
            }

            if (this.model.get(this.name) === 'custom') {
                // this.model.set(this.name, customLayoutName);
            }
        }
    });
});
