<?php
/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

namespace Espo\Modules\EblaLinkPro\Classes\FieldValidators;

use Espo\Core\Di\EntityManagerAware;
use Espo\Core\Di\EntityManagerSetter;
use Espo\Core\Di\FieldValidationManagerAware;
use Espo\Core\Di\FieldValidationManagerSetter;
use Espo\Core\Di\MetadataAware;
use Espo\Core\Di\MetadataSetter;
use Espo\Core\FieldValidation\Exceptions\ValidationError;
use Espo\Core\FieldValidation\FieldValidationParams as FieldValidationParams;
use Espo\ORM\Defs;
use Espo\ORM\Entity;
use Espo\ORM\Type\RelationType;

class LinkMultipleType implements FieldValidationManagerAware, EntityManagerAware, MetadataAware
{
    use FieldValidationManagerSetter;
    use EntityManagerSetter;
    use MetadataSetter;

    protected $validateSkipFieldList = ['assignedUser'];
    protected $validateRequiredSkipFieldList = [];

    private Defs $defs;

    public function __construct(Defs $defs)
    {
        $this->defs = $defs;
    }


    /**
     * @throws ValidationError
     */
    public function checkValid(Entity $entity, string $field): bool
    {
        $formEnabled = $this->metadata->get(['entityDefs', $entity->getEntityType(), 'fields', $field, 'enableForm'] ?? false);
        if (!$formEnabled) {
            return true;
        }

        $relationDefs = $this->defs
            ->getEntity($entity->getEntityType())
            ->getRelation($field);

        if ($relationDefs->getType() == RelationType::HAS_MANY || $relationDefs->getType() == RelationType::MANY_MANY) {
            return true;
        }

        $foreignField = $relationDefs
            ->getForeignRelationName();
        $this->validateSkipFieldList[] = $foreignField;

        $linkedEntityList = $entity->get($field . 'ListHolder');

        foreach ($linkedEntityList as $linkedEntityData) {
            $scope = $this->metadata->get(['entityDefs', $entity->getEntityType(), 'links', $field, 'entity'] ?? null);
            if (!$scope) {
                continue;
            }
            $linkedEntity = $this->entityManager->getNewEntity($scope);
            $linkedEntity->set($linkedEntityData);

            $params = FieldValidationParams
                ::create()
                ->withSkipFieldList($this->validateSkipFieldList)
                ->withTypeSkipFieldList('required', $this->validateRequiredSkipFieldList);

            $this->fieldValidationManager->process($linkedEntity, $linkedEntityData, $params);
        }

        return true;
    }

    public function checkRequired(Entity $entity, string $field): bool
    {
        return count(($entity->get($field . 'ListHolder')) ?? []) > 0 || count(($entity->getLinkMultipleIdList($field)) ?? []) > 0;
    }
}
