<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Api;

use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Record\EntityProvider;
use Espo\Core\Record\SearchParamsFetcher;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\Modules\Project\Tools\Project\PlanService;
use Espo\ORM\Collection;

/**
 * @noinspection PhpUnused
 */
class GetPlan implements Action
{
    public function __construct(
        private PlanService $service,
        private EntityProvider $entityProvider,
        private SearchParamsFetcher $searchParamsFetcher,
    ) {}

    public function process(Request $request): Response
    {
        $id = $request->getRouteParam('id') ?? throw new BadRequest();
        $searchParams = $this->searchParamsFetcher->fetch($request);
        $collapsedGroupIds = explode(',', $request->getQueryParam('collapsedGroupIds') ?? '');

        $project = $this->entityProvider->getByClass(Project::class, $id);

        $data = $this->service->get($project, $searchParams, $collapsedGroupIds);

        return ResponseComposer::json([
            'total' => $data->total,
            'groups' => array_map(
                /**
                 * @param array{0: ProjectGroup, 1: ?Collection<ProjectTask>, 2: ?int} $item
                 */
                function ($item) {
                    return [
                        'group' => $item[0]->getValueMap(),
                        'tasks' => [
                            'list' => $item[1] ? $item[1]->getValueMapList() : null,
                            'total' => $item[2],
                        ],
                    ];
                },
                $data->groups,
            )
        ]);
    }
}
