<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\FieldLoaders\Project;

use Espo\Core\FieldProcessing\Loader;
use Espo\Core\FieldProcessing\Loader\Params;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectColumn;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

/**
 * @implements Loader<Project>
 */
class FirstColumn implements Loader
{
    public function __construct(
        private EntityManager $entityManager,
    ) {}

    public function process(Entity $entity, Params $params): void
    {
        if ($params->hasSelect() && !$params->hasInSelect('firstColumnId')) {
            return;
        }

        if (!$entity->getBoardId()) {
            $entity->setMultiple([
                'firstColumnId' => null,
                'firstColumnName' => null,
            ]);

            return;
        }

        $column = $this->entityManager
            ->getRDBRepositoryByClass(ProjectColumn::class)
            ->select(['id', 'name'])
            ->where(['boardId' => $entity->getBoardId()])
            ->order('order')
            ->findOne();

        if (!$column) {
            return;
        }

        $entity->setMultiple([
            'firstColumnId' => $column->getId(),
            'firstColumnName' => $column->getName(),
        ]);
    }
}
