<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Hooks\Project;

use Espo\Core\Hook\Hook\AfterSave;
use Espo\Core\Hook\Hook\BeforeSave;
use Espo\Core\ORM\Repository\Option\SaveOption;
use Espo\Core\Utils\Language;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;
use Espo\ORM\Repository\Option\SaveOptions;

/**
 * @implements BeforeSave<Project>
 * @implements AfterSave<Project>
 */
class CreateEmptyGroup implements AfterSave, BeforeSave
{
    public function __construct(
        private EntityManager $entityManager,
        private Language $defaultLanguage,
    ) {}

    public function beforeSave(Entity $entity, SaveOptions $options): void
    {
        if (!$this->toProcess($entity, $options)) {
            return;
        }

        $this->entityManager->getTransactionManager()->start();

        $name = $this->defaultLanguage->translateLabel('defaultGroupName', 'strings', ProjectGroup::ENTITY_TYPE);

        $group = $this->entityManager->getRDBRepositoryByClass(ProjectGroup::class)->getNew();

        $group
            ->setProjectId($entity->getId())
            ->setName($name);

        $this->entityManager->saveEntity($group);

        $entity->setActiveGroupId($group->getId());
    }

    public function afterSave(Entity $entity, SaveOptions $options): void
    {
        if (!$this->toProcess($entity, $options)) {
            return;
        }

        $this->entityManager->getTransactionManager()->commit();
    }

    private function toProcess(Project $entity, SaveOptions $options): bool
    {
        return $entity->isNew() && $options->get(SaveOption::API);
    }
}
