/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/field-manager/link-multiple-form/middle-link', 'views/fields/enum', function (Dep) {

    return Dep.extend({

        setupOptions: function () {
            const scope = this.getMetadata().get(['entityDefs', this.options.scope, 'links', this.options.field, 'entity']);

            const links = this.getMetadata().get(['entityDefs', scope, 'links']) || {};

            this.params.options = Object.keys(Espo.Utils.clone(links)).filter(function (item) {
                if (links[item].disabled) return;
                if (links[item].entity === this.options.scope) return;
                if (!['belongsToParent', 'belongsTo', 'hasOne'].includes(links[item].type)) return;
                if (links[item].noJoin) return;

                return true;
            }, this);

            this.translatedOptions = {};
            this.params.options.forEach(function (item) {
                this.translatedOptions[item] = this.translate(item, 'links', scope);
            }, this);

            this.params.options = this.params.options.sort(function (v1, v2) {
                return this.translate(v1, 'links', scope).localeCompare(this.translate(v2, 'links', scope));
            }.bind(this));

            this.params.options.unshift('');
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            this.model.on('change:middleLink', () => {
                this.adjustMiddleLinkUniqueVisibility();
            }, this);
            this.adjustMiddleLinkUniqueVisibility();
        },

        adjustMiddleLinkUniqueVisibility: function () {
            this.getParentView().hideField('isMiddleLinkUnique');
            if (this.model.get('middleLink')) {
                this.getParentView().showField('isMiddleLinkUnique');
            }
        }
    });
});
