<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

namespace Espo\Modules\Sales\Classes\Record\Hooks\PriceRule;

use Espo\Core\Record\Hook\UpdateHook;
use Espo\Core\Record\UpdateParams;
use Espo\Modules\Sales\Entities\PriceRule;
use Espo\ORM\Entity;

/**
 * @implements UpdateHook<PriceRule>
 */
class BeforeUpdate implements UpdateHook
{
    public function process(Entity $entity, UpdateParams $params): void
    {
        if ($entity->getTarget() !== PriceRule::TARGET_PRODUCT_CATEGORY && $entity->has('productCategoryId')) {
            $entity->set('productCategoryId', null);
        }

        if ($entity->getTarget() !== PriceRule::TARGET_CONDITIONAL) {
            $entity->clear('conditionSelect');
        }

        if ($entity->getBasedOn() !== PriceRule::BASED_ON_SUPPLIER && $entity->has('supplierId')) {
            $entity->set('supplierId', null);
            $entity->set('supplierName', null);
        }
    }
}
