<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\FieldValidations\ProjectTask\Group;

use Espo\Core\FieldValidation\Validator;
use Espo\Core\FieldValidation\Validator\Data;
use Espo\Core\FieldValidation\Validator\Failure;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

/**
 * @implements Validator<ProjectTask>
 */
class Valid implements Validator
{
    public function __construct(
        private EntityManager $entityManager,
    ) {}

    public function validate(Entity $entity, string $field, Data $data): ?Failure
    {
        if (!$entity->getProjectId() || !$entity->getGroupId()) {
            return null;
        }

        $project = $this->entityManager
            ->getRDBRepositoryByClass(Project::class)
            ->getById($entity->getProjectId());

        if (!$project) {
            return null;
        }

        $isRelated = $this->entityManager
            ->getRelation($project, 'groups')
            ->isRelatedById($entity->getGroupId());

        if ($isRelated) {
            return null;
        }

        return Failure::create();
    }
}
