<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Entities;

use Espo\Core\Field\Date;
use Espo\Core\Field\DateTime;
use Espo\Core\Field\Link;
use Espo\Core\Field\LinkMultiple;
use Espo\Core\ORM\Entity;

class ProjectTask extends Entity
{
    public const ENTITY_TYPE = 'ProjectTask';

    public const STATUS_NOT_STARTED = 'Not Started';
    public const STATUS_STARTED = 'Started';
    public const STATUS_COMPLETED = 'Completed';
    public const STATUS_CANCELED = 'Canceled';
    public const STATUS_DEFERRED = 'Deferred';

    public const DEPENDENCY_TYPE_FS = 'fs';
    public const DEPENDENCY_TYPE_FF = 'ff';
    public const DEPENDENCY_TYPE_SS = 'ss';
    public const DEPENDENCY_TYPE_SF = 'sf';

    public const TYPE_TASK = 'Task';
    public const TYPE_MILESTONE = 'Milestone';

    public const PRIORITY_LOW = 'Low';
    public const PRIORITY_NORMAL = 'Normal';
    public const PRIORITY_HIGH = 'High';
    public const PRIORITY_URGENT = 'Urgent';

    public const ATTR_STATUS = 'status';

    public const RELATIONSHIP_PROJECT_TASK_PROJECT_TASK = 'ProjectTaskProjectTask';

    public function getName(): string
    {
        return $this->get('name');
    }

    public function getDescription(): ?string
    {
        return $this->get('description');
    }

    public function getPriority(): string
    {
        return $this->get('priority');
    }

    public function setPriority(string $priority): self
    {
        $this->set('priority', $priority);

        return $this;
    }

    public function isMilestone(): bool
    {
        return $this->getType() === self::TYPE_MILESTONE;
    }

    public function getType(): string
    {
        return $this->get('type');
    }

    public function setType(string $type): self
    {
        $this->set('type', $type);

        return $this;
    }

    public function getStatus(): string
    {
        return $this->get('status');
    }

    public function getFetchedStatus(): ?string
    {
        return $this->getFetched('status');
    }

    public function getAssignedUserId(): ?string
    {
        return $this->get('assignedUserId');
    }

    public function getOwnerId(): ?string
    {
        return $this->get('ownerId');
    }

    public function setStatus(string $status): self
    {
        $this->set('status', $status);

        return $this;
    }

    public function setBoardOrder(int $order): self
    {
        $this->set('boardOrder', $order);

        return $this;
    }

    public function setOrder(int $order): self
    {
        $this->set('order', $order);

        return $this;
    }

    public function getBoardId(): ?string
    {
        return $this->get('boardId');
    }

    public function getGroupId(): ?string
    {
        return $this->get('groupId');
    }

    public function getColumnId(): ?string
    {
        return $this->get('columnId');
    }

    public function getProjectId(): ?string
    {
        return $this->get('projectId');
    }

    public function getParentTaskId(): ?string
    {
        return $this->get('parentTaskId');
    }

    public function getBoardOrder(): int
    {
        return (int) $this->get('boardOrder');
    }

    public function getOrder(): int
    {
        return (int) $this->get('order');
    }

    public function getFromTasksLinkMultiple(): LinkMultiple
    {
        /** @var LinkMultiple */
        return $this->getValueObject('fromTasks');
    }

    public function setFromTasks(LinkMultiple $fromTasks): self
    {
        $this->setValueObject('fromTasks', $fromTasks);

        return $this;
    }

    public function getDateStart(): ?Date
    {
        $raw = $this->get('dateStart');

        if (!$raw) {
            return null;
        }

        return Date::fromString($raw);
    }

    public function getDateEnd(): ?Date
    {
        $raw = $this->get('dateEnd');

        if (!$raw) {
            return null;
        }

        return Date::fromString($raw);
    }

    public function setDateStart(?Date $dateStart): self
    {
        $this->setValueObject('dateStart', $dateStart);

        return $this;
    }

    public function setDateEnd(?Date $dateEnd): self
    {
        $this->setValueObject('dateEnd', $dateEnd);

        return $this;
    }

    public function setName(string $name): self
    {
        $this->set('name', $name);

        return $this;
    }

    public function setDescription(?string $description): self
    {
        $this->set('description', $description);

        return $this;
    }

    public function setColumnId(?string $columnId): self
    {
        $this->set('columnId', $columnId);

        return $this;
    }

    public function setGroupId(?string $groupId): self
    {
        $this->set('groupId', $groupId);

        return $this;
    }

    public function setGroup(?Link $group): self
    {
        $this->setValueObject('group', $group);

        return $this;
    }

    public function setProjectId(string $projectId): self
    {
        $this->set('projectId', $projectId);

        return $this;
    }

    public function setParentTaskId(?string $parentTaskId): self
    {
        $this->set('parentTaskId', $parentTaskId);

        return $this;
    }

    public function setColumnLink(?Link $link): self
    {
        $this->setValueObject('column', $link);

        return $this;
    }

    public function getFromTasks(): LinkMultiple
    {
        /** @var LinkMultiple */
        return $this->getValueObject('fromTasks');
    }

    public function getHours(): ?float
    {
        return $this->get('hours');
    }

    public function getPoints(): ?int
    {
        return $this->get('points');
    }

    public function setHours(?float $hours): self
    {
        $this->set('hours', $hours);

        return $this;
    }

    public function setPoints(?int $points): self
    {
        $this->set('points', $points);

        return $this;
    }

    public function setCompletedAt(?DateTime $completedAt): self
    {
        $this->setValueObject('completedAt', $completedAt);

        return $this;
    }

    public function setAssignedUserId(?string $assignedUserId): self
    {
        $this->set('assignedUserId', $assignedUserId);

        return $this;
    }

    public function setOwnerId(?string $ownerId): self
    {
        $this->set('ownerId', $ownerId);

        return $this;
    }
}
