<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

namespace Espo\Modules\Sales\Classes\Jobs;

use Espo\Core\Field\Date;
use Espo\Core\Job\JobDataLess;
use Espo\Core\Utils\Config;
use Espo\Modules\Sales\Tools\Inventory\Archive\Compressor;
use Espo\Modules\Sales\Tools\Inventory\Archive\Params;

/**
 * @noinspection PhpUnused
 */
class InventoryCompress implements JobDataLess
{
    private const DEFAULT_PERIOD = '1 months';

    public function __construct(
        private Compressor $compressor,
        private Config $config
    ) {}

    public function run(): void
    {
        $period = $this->config->get('inventoryCompressJobPeriod') ?? self::DEFAULT_PERIOD;
        $date = Date::createToday()->modify('-' . $period);

        $params = new Params($date);

        $this->compressor->run($params);
    }
}
