/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2021 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

define('views/edit', 'views/main', function (Dep) {

    return Dep.extend({

        template: 'edit',

        scope: null,

        name: 'Edit',

        menu: null,

        optionsToPass: ['returnUrl', 'returnDispatchParams', 'attributes', 'rootUrl'],

        headerView: 'views/header',

        recordView: 'views/record/edit',

        rootLinkDisabled: false,

        setup: function () {
            this.headerView = this.options.headerView || this.headerView;
            this.recordView = this.options.recordView || this.recordView;

            this.setupHeader();
            this.setupRecord();

            this.getHelper().processSetupHandlers(this, 'edit');
        },

        setupHeader: function () {
            this.createView('header', this.headerView, {
                model: this.model,
                el: '#main > .header',
                scope: this.scope,
            });
        },

        setupRecord: function () {
            var o = {
                model: this.model,
                el: '#main > .record',
                scope: this.scope,
            };

            this.optionsToPass.forEach(function (option) {
                o[option] = this.options[option];
            }, this);

            if (this.options.params && this.options.params.rootUrl) {
                o.rootUrl = this.options.params.rootUrl;
            }

            return this.createView('record', this.getRecordViewName(), o);
        },

        getRecordViewName: function () {
            return this.getMetadata().get('clientDefs.' + this.scope + '.recordViews.edit') || this.recordView;
        },

        getHeader: function () {
            var headerIconHtml = this.getHeaderIconHtml();

            var arr = [];

            if (this.options.noHeaderLinks || this.rootLinkDisabled) {
                arr.push(this.getLanguage().translate(this.scope, 'scopeNamesPlural'));
            }
            else {
                var rootUrl = this.options.rootUrl || this.options.params.rootUrl || '#' + this.scope;

                arr.push(
                    headerIconHtml + '<a href="' + rootUrl + '" class="action" data-action="navigateToRoot">' +
                    this.getLanguage().translate(this.scope, 'scopeNamesPlural') + '</a>'
                );
            }

            if (this.model.isNew()) {
                arr.push(this.getLanguage().translate('create'));
            }
            else {
                var name = Handlebars.Utils.escapeExpression(this.model.get('name'));

                if (name === '') {
                    name = this.model.id;
                }

                if (this.options.noHeaderLinks) {
                    arr.push(name);
                }
                else {
                    arr.push(
                        '<a href="#' + this.scope + '/view/' + this.model.id + '" class="action">' + name + '</a>'
                    );
                }
            }

            return this.buildHeaderHtml(arr);
        },

        updatePageTitle: function () {
            var title;

            if (this.model.isNew()) {
                title = this.getLanguage().translate('Create') + ' ' +
                    this.getLanguage().translate(this.scope, 'scopeNames');
            }
            else {
                var name = this.model.get('name');

                if (name) {
                    title = name;
                }
                else {
                    title = this.getLanguage().translate(this.scope, 'scopeNames')
                }
            }

            this.setPageTitle(title);
        },
    });
});
