/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define('advanced:views/bpmn-flowchart-element/record/detail', ['views/record/detail-small'], function (Dep) {

    return Dep.extend({

        setup: function () {
            this.dynamicLogicDefs = this.options.dynamicLogicDefs;

            Dep.prototype.setup.call(this);

            if (!this.model.get('description')) {
                this.hideField('description');
                this.hidePanel('description');
            }

            if (!this.model.get('text')) {
                this.hideField('text');
                this.hidePanel('text');
            }

            var flowchartData = {
                list: this.model.get('dataList'),
                createdEntitiesData: this.model.flowchartCreatedEntitiesData,
            };

            this.model.set('flowchartData', flowchartData);
        },
    });
});
