/*!
 * Cropper v0.7.9
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014-2015 Fengyuan Chen
 * Released under the MIT license
 */
(t=>{"function"==typeof define&&define.amd?define(["jquery"],t):"object"==typeof exports?t(require("jquery")):t(jQuery)})(function(g){function s(t,i){var e=[];R(i)&&e.push(i);return e.slice.apply(t,e)}function i(t,i){var e=s(arguments,2);return function(){return t.apply(i,e.concat(s(arguments)))}}function r(t,i){this.element=t;this.$element=g(t);this.defaults=g.extend({},r.DEFAULTS,g.isPlainObject(i)?i:{});this.$original=d;this.ready=D;this.built=D;this.cropped=D;this.rotated=D;this.disabled=D;this.replaced=D;this.init()}var e=g(window),h=g(document),a=window.location,$=!0,D=!1,d=null,n="undefined",o="directive",t=".cropper",E=/^(e|n|w|s|ne|nw|sw|se|all|crop|move|zoom)$/,_=/^(x|y|width|height)$/,P=/^(naturalWidth|naturalHeight|width|height|aspectRatio|ratio|rotate)$/,l="cropper-modal",C="cropper-hidden",f="cropper-invisible",p="cropper-crop",c="cropper-disabled",m="mousedown touchstart",u="mousemove touchmove",w="mouseup mouseleave touchend touchleave touchcancel",v="wheel mousewheel DOMMouseScroll",x="resize"+t,b="dblclick",y="build"+t,W="built"+t,H="dragstart"+t,k="dragmove"+t,L="dragend"+t,R=function(t){return"number"==typeof t},Y=Math.sqrt,z=Math.min,X=Math.max,T=Math.abs,M=Math.sin,O=Math.cos,I=parseFloat;r.prototype={constructor:r,support:{canvas:g.isFunction(g("<canvas>")[0].getContext)},init:function(){var e=this.defaults;g.each(e,function(t,i){switch(t){case"aspectRatio":e[t]=T(I(i))||NaN;break;case"autoCropArea":e[t]=T(I(i))||.8;break;case"minWidth":case"minHeight":e[t]=T(I(i))||0;break;case"maxWidth":case"maxHeight":e[t]=T(I(i))||1/0}});this.image={rotate:0};this.load()},load:function(){var t,i,e,h=this,a=this.$element,s=this.element,r=this.image,d="";a.is("img")?i=a.prop("src"):a.is("canvas")&&this.support.canvas&&(i=s.toDataURL());if(i){this.replaced&&(r.rotate=0);if(this.defaults.checkImageOrigin&&this.isCrossOriginURL(i)){d=" crossOrigin";i=(e=i,a="timestamp="+(new Date).getTime(),e+(-1===e.indexOf("?")?"?":"&")+a)}this.$clone=t=g("<img"+d+' src="'+i+'">');t.one("load",function(){r.naturalWidth=this.naturalWidth||t.width();r.naturalHeight=this.naturalHeight||t.height();r.aspectRatio=r.naturalWidth/r.naturalHeight;h.url=i;h.ready=$;h.build()});t.addClass(f).prependTo("body")}},isCrossOriginURL:function(t){var i=t.match(/^(https?:)\/\/([^\:\/\?#]+):?(\d*)/i);return!i||i[1]===a.protocol&&i[2]===a.hostname&&i[3]===a.port?D:$},build:function(){var t,i=this.$element,e=this.defaults;if(this.ready){this.built&&this.unbuild();i.one(y,e.build);t=g.Event(y);i.trigger(t);if(!t.isDefaultPrevented()){this.$cropper=t=g(r.TEMPLATE);i.addClass(C);this.$clone.removeClass(f).prependTo(t);if(!this.rotated){this.$original=this.$clone.clone();this.$original.addClass(C).prependTo(this.$cropper);this.originalImage=g.extend({},this.image)}this.$container=i.parent();this.$container.append(t);this.$canvas=t.find(".cropper-canvas");this.$dragger=t.find(".cropper-dragger");this.$viewer=t.find(".cropper-viewer");e.autoCrop?this.cropped=$:this.$dragger.addClass(C);e.modal&&this.$canvas.addClass(l);e.dashed||this.$dragger.find(".cropper-dashed").addClass(C);e.movable||this.$dragger.find(".cropper-face").data(o,"move");e.resizable||this.$dragger.find(".cropper-line, .cropper-point").addClass(C);this.addListeners();this.initPreview();this.built=$;e.dragCrop&&this.setDragMode("crop");this.update();this.replaced=D;i.one(W,e.built);i.trigger(W)}}},unbuild:function(){if(this.built){this.built=D;this.removeListeners();this.$preview.empty();this.$preview=d;this.$dragger=d;this.$canvas=d;this.$container=d;this.$cropper.remove();this.$cropper=d}},update:function(t){this.initContainer();this.initCropper();this.initImage();this.initDragger();if(t){this.setData(t,$);this.setDragMode("crop")}else this.setData(this.defaults.data)},resize:function(){clearTimeout(this.resizing);this.resizing=setTimeout(g.proxy(this.update,this,this.getData()),200)},preview:function(){var t=this.image,s=this.dragger,r=t.width,d=t.height,n=s.left-t.left,o=s.top-t.top;this.$viewer.find("img").css({width:r,height:d,marginLeft:-n,marginTop:-o});this.$preview.each(function(){var t=g(this),i=t.data(),e=i.width/s.width,h=i.width,a=s.height*e;if(i.height<a){e=i.height/s.height,h=s.width*e;a=i.height}t.width(h).height(a).find("img").css({width:r*e,height:d*e,marginLeft:-n*e,marginTop:-o*e})})},addListeners:function(){var t=this.defaults;this.$element.on(H,t.dragstart).on(k,t.dragmove).on(L,t.dragend);this.$cropper.on(m,g.proxy(this.dragstart,this)).on(b,g.proxy(this.dblclick,this));t.zoomable&&this.$cropper.on(v,g.proxy(this.wheel,this));t.multiple?this.$cropper.on(u,g.proxy(this.dragmove,this)).on(w,g.proxy(this.dragend,this)):h.on(u,this._dragmove=i(this.dragmove,this)).on(w,this._dragend=i(this.dragend,this));e.on(x,this._resize=i(this.resize,this))},removeListeners:function(){var t=this.defaults;this.$element.off(H,t.dragstart).off(k,t.dragmove).off(L,t.dragend);this.$cropper.off(m,this.dragstart).off(b,this.dblclick);t.zoomable&&this.$cropper.off(v,this.wheel);t.multiple?this.$cropper.off(u,this.dragmove).off(w,this.dragend):h.off(u,this._dragmove).off(w,this._dragend);e.off(x,this._resize)},initPreview:function(){var i=this.url;this.$preview=g(this.defaults.preview);this.$viewer.html('<img src="'+i+'">');this.$preview.each(function(){var t=g(this);t.data({width:t.width(),height:t.height()}).html('<img src="'+i+'" style="display:block;width:100%;min-width:0!important;min-height:0!important;max-width:none!important;max-height:none!important;">')})},initContainer:function(){var t=this.$element,i=this.$container,e=this.$cropper,h=this.defaults;e.addClass(C);t.removeClass(C);this.container={width:X(i.width(),h.minContainerWidth),height:X(i.height(),h.minContainerHeight)};t.addClass(C);e.removeClass(C)},initCropper:function(){var t,i=this.container,e=this.image;if(0<=e.naturalWidth*i.height/e.naturalHeight-i.width){t={width:i.width,height:i.width/e.aspectRatio,left:0};t.top=(i.height-t.height)/2}else{t={width:i.height*e.aspectRatio,height:i.height,top:0};t.left=(i.width-t.width)/2}this.$cropper.css({width:t.width,height:t.height,left:t.left,top:t.top});this.cropper=t},initImage:function(){var t=this.image,i=this.cropper,e={_width:i.width,_height:i.height,width:i.width,height:i.height,left:0,top:0,ratio:i.width/t.naturalWidth};this.defaultImage=g.extend({},t,e);if(t._width!==i.width||t._height!==i.height)g.extend(t,e);else{t=g.extend({},e,t);this.replaced&&(t.ratio=e.ratio)}this.image=t;this.renderImage()},renderImage:function(t){var i=this.image;if("zoom"===t){i.left-=(i.width-i.oldWidth)/2;i.top-=(i.height-i.oldHeight)/2}i.left=z(X(i.left,i._width-i.width),0);i.top=z(X(i.top,i._height-i.height),0);this.$clone.css({width:i.width,height:i.height,marginLeft:i.left,marginTop:i.top});if(t){this.defaults.done(this.getData());this.preview()}},initDragger:function(){var t=this.defaults,i=this.cropper,e=t.aspectRatio||this.image.aspectRatio,h=this.image.ratio,a=0<=i.height*e-i.width?{height:i.width/e,width:i.width,left:0,top:(i.height-i.width/e)/2,maxWidth:i.width,maxHeight:i.width/e}:{height:i.height,width:i.height*e,left:(i.width-i.height*e)/2,top:0,maxWidth:i.height*e,maxHeight:i.height};a.minWidth=0;a.minHeight=0;if(t.aspectRatio){if(isFinite(t.maxWidth)){a.maxWidth=z(a.maxWidth,t.maxWidth*h);a.maxHeight=a.maxWidth/e}else if(isFinite(t.maxHeight)){a.maxHeight=z(a.maxHeight,t.maxHeight*h);a.maxWidth=a.maxHeight*e}if(0<t.minWidth){a.minWidth=X(0,t.minWidth*h);a.minHeight=a.minWidth/e}else if(0<t.minHeight){a.minHeight=X(0,t.minHeight*h);a.minWidth=a.minHeight*e}}else{a.maxWidth=z(a.maxWidth,t.maxWidth*h);a.maxHeight=z(a.maxHeight,t.maxHeight*h);a.minWidth=X(0,t.minWidth*h);a.minHeight=X(0,t.minHeight*h)}a.minWidth=z(a.maxWidth,a.minWidth);a.minHeight=z(a.maxHeight,a.minHeight);e=g.extend({},a);e.width=X(a.minWidth,a.width*t.autoCropArea);e.height=X(a.minHeight,a.height*t.autoCropArea);e.left=(i.width-e.width)/2;e.top=(i.height-e.height)/2;e.oldLeft=a.oldLeft=a.left;e.oldTop=a.oldTop=a.top;this.autoCropDragger=e;this.defaultDragger=g.extend({},a);this.dragger=a},renderDragger:function(){var t=this.dragger,i=this.cropper;if(t.width>t.maxWidth){t.width=t.maxWidth;t.left=t.oldLeft}else if(t.width<t.minWidth){t.width=t.minWidth;t.left=t.oldLeft}if(t.maxHeight<t.height){t.height=t.maxHeight;t.top=t.oldTop}else if(t.height<t.minHeight){t.height=t.minHeight;t.top=t.oldTop}t.left=z(X(t.left,0),i.width-t.width);t.top=z(X(t.top,0),i.height-t.height);t.oldLeft=t.left;t.oldTop=t.top;this.dragger=t;this.defaults.movable&&this.$dragger.find(".cropper-face").data(o,t.width===i.width&&t.height===i.height?"move":"all");this.disabled||this.defaults.done(this.getData());this.$dragger.css({width:t.width,height:t.height,left:t.left,top:t.top});this.preview()},reset:function(t){if(this.cropped&&!this.disabled){t&&(this.defaults.data={});this.image=g.extend({},this.defaultImage);this.renderImage();this.dragger=g.extend({},this.defaultDragger);this.setData(this.defaults.data)}},clear:function(){if(this.cropped&&!this.disabled){this.cropped=D;this.setData({x:0,y:0,width:0,height:0});this.$canvas.removeClass(l);this.$dragger.addClass(C)}},destroy:function(){var t=this.$element;this.ready||this.$clone.off("load").remove();this.unbuild();t.removeClass(C).removeData("cropper");this.rotated&&t.attr("src",this.$original.attr("src"))},replace:function(t,i){var e,h=this,a=this.$element,s=this.element;if(!this.disabled&&t&&t!==this.url&&t!==a.attr("src")){if(!i){this.rotated=D;this.replaced=$}if(a.is("img")){a.attr("src",t);this.load()}else if(a.is("canvas")&&this.support.canvas){e=s.getContext("2d");g('<img src="'+t+'">').one("load",function(){s.width=this.width;s.height=this.height;e.clearRect(0,0,s.width,s.height);e.drawImage(this,0,0);h.load()})}}},setData:function(t,i){var e=this.cropper,h=this.dragger,a=this.image,s=this.defaults.aspectRatio;if(this.built&&!this.disabled&&typeof t!=n){t!==d&&!g.isEmptyObject(t)||(h=g.extend({},this.autoCropDragger));if(g.isPlainObject(t)&&!g.isEmptyObject(t)){i||(this.defaults.data=t);t=this.transformData(t);R(t.x)&&t.x<=e.width-a.left&&(h.left=t.x+a.left);R(t.y)&&t.y<=e.height-a.top&&(h.top=t.y+a.top);if(s){if(R(t.width)&&t.width<=h.maxWidth&&t.width>=h.minWidth){h.width=t.width;h.height=h.width/s}else if(R(t.height)&&t.height<=h.maxHeight&&t.height>=h.minHeight){h.height=t.height;h.width=h.height*s}}else{R(t.width)&&t.width<=h.maxWidth&&t.width>=h.minWidth&&(h.width=t.width);R(t.height)&&t.height<=h.maxHeight&&t.height>=h.minHeight&&(h.height=t.height)}}this.dragger=h;this.renderDragger()}},getData:function(t){var i=this.dragger,e=this.image,h={};if(this.built){h={x:i.left-e.left,y:i.top-e.top,width:i.width,height:i.height};h=this.transformData(h,$,t)}return h},transformData:function(t,e,h){var a=this.image.ratio,s={};g.each(t,function(t,i){i=I(i);_.test(t)&&!isNaN(i)&&(s[t]=e?h?Math.round(i/a):i/a:i*a)});return s},setAspectRatio:function(t){var i="auto"===t;if(!this.disabled){t=I(t);if(i||!isNaN(t)&&0<t){this.defaults.aspectRatio=i?NaN:t;if(this.built){this.initDragger();this.renderDragger();this.setData(this.defaults.data)}}}},getImageData:function(){var e={};this.ready&&g.each(this.image,function(t,i){P.test(t)&&(e[t]=i)});return e},getDataURL:function(t,i,e){var h,a=g("<canvas>")[0],s=this.getData(),r="";if(!g.isPlainObject(t)){e=i;i=t;t={}}t=g.extend({width:s.width,height:s.height},t);if(this.cropped&&this.support.canvas){a.width=t.width;a.height=t.height;h=a.getContext("2d");if("image/jpeg"===i){h.fillStyle="#fff";h.fillRect(0,0,t.width,t.height)}h.drawImage(this.$clone[0],s.x,s.y,s.width,s.height,0,0,t.width,t.height);r=a.toDataURL(i,e)}return r},setDragMode:function(t){var i=this.$canvas,e=this.defaults,h=D,a=D;if(this.built&&!this.disabled){switch(t){case"crop":if(e.dragCrop){h=$;i.data(o,t)}break;case"move":a=$;i.data(o,t);break;default:i.removeData(o)}i.toggleClass(p,h).toggleClass("cropper-move",a)}},enable:function(){if(this.built){this.disabled=D;this.$cropper.removeClass(c)}},disable:function(){if(this.built){this.disabled=$;this.$cropper.addClass(c)}},rotate:function(t){var i=this.image;t=I(t)||0;if(this.built&&0!==t&&!this.disabled&&this.defaults.rotatable&&this.support.canvas){this.rotated=$;t=i.rotate=(i.rotate+t)%360;this.replace(this.getRotatedDataURL(t),!0)}},getRotatedDataURL:function(t){var i=g("<canvas>")[0],e=i.getContext("2d"),h=this.originalImage,a=h.naturalWidth,h=h.naturalHeight,s=T(t)%180,s=(90<s?180-s:s)*Math.PI/180,r=a*O(s)+h*M(s),s=a*M(s)+h*O(s);i.width=r;i.height=s;e.save();e.translate(r/2,s/2);e.rotate(t*Math.PI/180);e.drawImage(this.$original[0],-a/2,-h/2,a,h);e.restore();return i.toDataURL()},zoom:function(t){var i,e,h,a=this.image;t=I(t);if(this.built&&t&&!this.disabled&&this.defaults.zoomable){i=a.width*(1+t);e=a.height*(1+t);h=i/a._width;if(!(10<h)){if(h<1){i=a._width;e=a._height}h<=1?this.setDragMode("crop"):this.setDragMode("move");a.oldWidth=a.width;a.oldHeight=a.height;a.width=i;a.height=e;a.ratio=a.width/a.naturalWidth;this.renderImage("zoom")}}},dblclick:function(){this.disabled||(this.$canvas.hasClass(p)?this.setDragMode("move"):this.setDragMode("crop"))},wheel:function(t){var i=t.originalEvent,e=1;if(!this.disabled){t.preventDefault();i.deltaY?e=0<i.deltaY?1:-1:i.wheelDelta?e=-i.wheelDelta/120:i.detail&&(e=0<i.detail?1:-1);this.zoom(.1*e)}},dragstart:function(t){var i,e,h=t.originalEvent.touches,a=t;if(!this.disabled){if(h){e=h.length;if(1<e){if(!this.defaults.zoomable||2!==e)return;a=h[1];this.startX2=a.pageX;this.startY2=a.pageY;i="zoom"}a=h[0]}i=i||g(a.target).data(o);if(E.test(i)){t.preventDefault();e=g.Event(H);this.$element.trigger(e);if(!e.isDefaultPrevented()){this.directive=i;this.cropping=D;this.startX=a.pageX;this.startY=a.pageY;if("crop"===i){this.cropping=$;this.$canvas.addClass(l)}}}}},dragmove:function(t){var i,e=t.originalEvent.touches,h=t;if(!this.disabled){if(e){i=e.length;if(1<i){if(!this.defaults.zoomable||2!==i)return;h=e[1];this.endX2=h.pageX;this.endY2=h.pageY}h=e[0]}if(this.directive){t.preventDefault();i=g.Event(k);this.$element.trigger(i);if(!i.isDefaultPrevented()){this.endX=h.pageX;this.endY=h.pageY;this.dragging()}}}},dragend:function(t){var i;if(!this.disabled&&this.directive){t.preventDefault();i=g.Event(L);this.$element.trigger(i);if(!i.isDefaultPrevented()){if(this.cropping){this.cropping=D;this.$canvas.toggleClass(l,this.cropped&&this.defaults.modal)}this.directive=""}}},dragging:function(){var t,i,e,h,a,s,r,d=this.directive,n=this.image,o=this.cropper,g=o.width,l=o.height,f=this.dragger,p=f.width,c=f.height,m=f.left,u=f.top,w=m+p,v=u+c,x=$,b=this.defaults.aspectRatio,y={x:this.endX-this.startX,y:this.endY-this.startY};if(b){y.X=y.y*b;y.Y=y.x/b}switch(d){case"all":m+=y.x;u+=y.y;break;case"e":if(0<=y.x&&(g<=w||b&&(u<=0||l<=v)))x=D;else{p+=y.x;if(b){c=p/b;u-=y.Y/2}if(p<0){d="w";p=0}}break;case"n":if(y.y<=0&&(u<=0||b&&(m<=0||g<=w)))x=D;else{c-=y.y;u+=y.y;if(b){p=c*b;m+=y.X/2}if(c<0){d="s";c=0}}break;case"w":if(y.x<=0&&(m<=0||b&&(u<=0||l<=v)))x=D;else{p-=y.x;m+=y.x;if(b){c=p/b;u+=y.Y/2}if(p<0){d="e";p=0}}break;case"s":if(0<=y.y&&(l<=v||b&&(m<=0||g<=w)))x=D;else{c+=y.y;if(b){p=c*b;m-=y.X/2}if(c<0){d="n";c=0}}break;case"ne":if(b){if(y.y<=0&&(u<=0||g<=w)){x=D;break}c-=y.y;u+=y.y;p=c*b}else{!(0<=y.x)||w<g?p+=y.x:y.y<=0&&u<=0&&(x=D);if(y.y<=0){if(0<u){c-=y.y;u+=y.y}}else{c-=y.y;u+=y.y}}if(p<0&&c<0){d="sw";c=0;p=0}else if(p<0){d="nw";p=0}else if(c<0){d="se";c=0}break;case"nw":if(b){if(y.y<=0&&(u<=0||m<=0)){x=D;break}c-=y.y;u+=y.y;p=c*b;m+=y.X}else{if(y.x<=0)if(0<m){p-=y.x;m+=y.x}else y.y<=0&&u<=0&&(x=D);else{p-=y.x;m+=y.x}if(y.y<=0){if(0<u){c-=y.y;u+=y.y}}else{c-=y.y;u+=y.y}}if(p<0&&c<0){d="se";c=0;p=0}else if(p<0){d="ne";p=0}else if(c<0){d="sw";c=0}break;case"sw":if(b){if(y.x<=0&&(m<=0||l<=v)){x=D;break}p-=y.x;m+=y.x;c=p/b}else{if(y.x<=0)if(0<m){p-=y.x;m+=y.x}else 0<=y.y&&l<=v&&(x=D);else{p-=y.x;m+=y.x}(!(0<=y.y)||v<l)&&(c+=y.y)}if(p<0&&c<0){d="ne";c=0;p=0}else if(p<0){d="se";p=0}else if(c<0){d="nw";c=0}break;case"se":if(b){if(0<=y.x&&(g<=w||l<=v)){x=D;break}p+=y.x;c=p/b}else{!(0<=y.x)||w<g?p+=y.x:0<=y.y&&l<=v&&(x=D);(!(0<=y.y)||v<l)&&(c+=y.y)}if(p<0&&c<0){d="nw";c=0;p=0}else if(p<0){d="sw";p=0}else if(c<0){d="ne";c=0}break;case"move":n.left+=y.x;n.top+=y.y;this.renderImage("move");x=D;break;case"zoom":this.zoom((i=n.width,e=n.height,h=T(this.startX-this.startX2),a=T(this.startY-this.startY2),s=T(this.endX-this.endX2),r=T(this.endY-this.endY2),(Y(s*s+r*r)-Y(h*h+a*a))/Y(i*i+e*e)));this.endX2=this.startX2;this.endY2=this.startY2;x=D;break;case"crop":if(y.x&&y.y){t=this.$cropper.offset();m=this.startX-t.left;u=this.startY-t.top;p=f.minWidth;c=f.minHeight;if(0<y.x)if(0<y.y)d="se";else{d="ne";u-=c}else if(0<y.y){d="sw";m-=p}else{d="nw";m-=p;u-=c}if(!this.cropped){this.cropped=$;this.$dragger.removeClass(C)}}}if(x){f.width=p;f.height=c;f.left=m;f.top=u;this.directive=d;this.renderDragger()}this.startX=this.endX;this.startY=this.endY}};r.TEMPLATE=((t,i)=>{i="div,span,directive,data,point,cropper,class,line,dashed".split(",");return'<0 6="5-container"><0 6="5-canvas"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="all"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>'.replace(/\d+/g,function(t){return i[t]})})();r.DEFAULTS={aspectRatio:"auto",autoCropArea:.8,data:{},done:g.noop,preview:"",multiple:D,autoCrop:$,dragCrop:$,dashed:$,modal:$,movable:$,resizable:$,zoomable:$,rotatable:$,checkImageOrigin:$,minWidth:0,minHeight:0,maxWidth:1/0,maxHeight:1/0,minContainerWidth:300,minContainerHeight:150,build:d,built:d,dragstart:d,dragmove:d,dragend:d};r.setDefaults=function(t){g.extend(r.DEFAULTS,t)};r.other=g.fn.cropper;g.fn.cropper=function(e){var h,a=s(arguments,1);this.each(function(){var t=g(this),i=t.data("cropper");i||t.data("cropper",i=new r(this,e));"string"==typeof e&&g.isFunction(t=i[e])&&(h=t.apply(i,a))});return typeof h!=n?h:this};g.fn.cropper.Constructor=r;g.fn.cropper.setDefaults=r.setDefaults;g.fn.cropper.noConflict=function(){g.fn.cropper=r.other;return this}});
//# sourceMappingURL=cropper.js.map