<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\FieldLoaders\ProjectTask;

use Espo\Core\FieldProcessing\Loader;
use Espo\Core\FieldProcessing\Loader\Params;
use Espo\Entities\User;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\Modules\Project\Tools\Project\MemberRoleProvider;
use Espo\ORM\Entity;

/**
 * @implements Loader<ProjectTask>
 */
class MemberRoleData implements Loader
{
    public function __construct(
        private User $user,
        private MemberRoleProvider $memberRoleProvider,
    ) {}

    public function process(Entity $entity, Params $params): void
    {
        if (!$entity->getProjectId()) {
            /** @noinspection PhpRedundantOptionalArgumentInspection */
            $entity->set('memberRoleData', null);

            return;
        }

        $memberRole = $this->memberRoleProvider->get($this->user, $entity->getProjectId());

        if (!$memberRole) {
            /** @noinspection PhpRedundantOptionalArgumentInspection */
            $entity->set('memberRoleData', null);

            return;
        }

        $entity->set('memberRoleData', [
            'role' => $memberRole->role,
            'permissions' => $memberRole->record->getPermissionMap(),
        ]);
    }
}
