<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Entities;

use Espo\Core\Field\Date;
use Espo\Core\ORM\Entity;

class Project extends Entity
{
    public const ENTITY_TYPE = 'Project';

    public const STATUS_DRAFT = 'Draft';
    public const STATUS_ACTIVE = 'Active';
    public const STATUS_CLOSED = 'Closed';
    public const STATUS_PAUSED = 'Paused';
    public const STATUS_CANCELED = 'Canceled';

    public const ROLE_MEMBER = 'Member';
    public const ROLE_EDITOR = 'Editor';
    public const ROLE_OWNER = 'Owner';

    public const RELATIONSHIP_PROJECT_USER = 'ProjectUser';

    public const RELATION_MEMBERS = 'members';
    public const RELATION_GROUPS = 'groups';

    public function getName(): string
    {
        return $this->get('name');
    }

    public function setName(string $name): self
    {
        $this->set('name', $name);

        return $this;
    }

    public function setDateStart(?Date $dateStart): self
    {
        $this->setValueObject('dateStart', $dateStart);

        return $this;
    }

    public function setDateEnd(?Date $dateEnd): self
    {
        $this->setValueObject('dateEnd', $dateEnd);

        return $this;
    }

    public function getDateStart(): ?Date
    {
        /** @var ?Date */
        return $this->getValueObject('dateStart');
    }

    public function getDateEnd(): ?Date
    {
        /** @var ?Date */
        return $this->getValueObject('dateEnd');
    }

    public function getDescription(): ?string
    {
        return $this->get('description');
    }

    public function getStatus(): string
    {
        return $this->get('status');
    }

    public function setStatus(string $status): self
    {
        $this->set('status', $status);

        return $this;
    }

    public function setBoardId(string $boardId): self
    {
        $this->set('boardId', $boardId);

        return $this;
    }

    public function setActiveGroupId(?string $groupId): self
    {
        $this->set('activeGroupId', $groupId);

        return $this;
    }

    public function getActiveGroupId(): ?string
    {
        return $this->get('activeGroupId');
    }

    public function getBoardId(): ?string
    {
        return $this->get('boardId');
    }

    public function hasGanttView(): bool
    {
        return (bool) $this->get('ganttView');
    }

    public function setGanttView(bool $ganttView): self
    {
        $this->set('ganttView', $ganttView);

        return $this;
    }

    public function setDescription(?string $description): self
    {
        $this->set('description', $description);

        return $this;
    }
}
