/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define('advanced:views/report/fields/columns-control', ['views/fields/base', 'model'], function (Dep, Model) {

    return Dep.extend({

        editTemplate: 'advanced:report/fields/filters-control/edit',
        detailTemplate: 'advanced:report/fields/filters-control/detail',

        fieldDataList: [
            {
                name: 'width',
                view: 'views/fields/float',
            },
            {
                name: 'align',
                view: 'views/fields/enum',
                params: {
                    options: ["left", "right"],
                    translation: 'Report.options.layoutAlign',
                },
            },
            {
                name: 'link',
                view: 'views/fields/bool',
            },
            {
                name: 'exportOnly',
                view: 'views/fields/bool',
            },
            {
                name: 'notSortable',
                view: 'views/fields/bool',
            },
        ],

        setup: function () {
            this.entityType = this.model.get('entityType');

            this.seed = new Model();
            this.seed.name = 'LayoutManager';

            this.setupColumnsData();

            this.listenTo(this.model, 'change:columns', () => {
                const previousColumnList = Espo.Utils.clone(this.columnList);
                const toAdd = [];
                const toRemove = [];

                this.setupColumnsData();

                const columnList = this.columnList;

                columnList.forEach(name => {
                    if (!~previousColumnList.indexOf(name)) {
                        toAdd.push(name);
                    }
                });

                previousColumnList.forEach(name => {
                    if (!~columnList.indexOf(name)) {
                        toRemove.push(name);
                    }
                });

                if (this.isRendered()) {
                    toAdd.forEach(name => {
                        this.createColumn(name);
                    });

                    toRemove.forEach(name => {
                        this.removeColumn(name);
                    });
                }
            });
        },

        setupColumnsData: function () {
            this.columnList = Espo.Utils.clone(this.model.get('columns')) || [];
        },

        afterRender: function () {
            this.columnList.forEach(name => {
                const params = (this.model.get('columnsData') || {})[name];

                this.createColumn(name, params);
            });
        },

        removeColumn: function (name) {
            this.clearView(`name-${name}`);

            this.$el.find(`.filters-row > .column[data-name="${name}"]`).remove();

            this.fieldDataList.forEach(item => {
                this.clearView(`field-${name}-${item.name}`);
            });
        },

        createColumn: function (name) {
            let label;

            if (~name.indexOf('.')) {
                const link = name.split('.')[0];
                const field = name.split('.')[1];

                const scope = this.getMetadata().get(`entityDefs.${this.entityType}.links.${link}.entity`);

                label = this.translate(link, 'links', this.entityType) + ' . ' + this.translate(field, 'fields', scope);
            } else {
                label = this.translate(name, 'fields', this.entityType);
            }

            const $filtersRow = this.$el.find('.filters-row');

            const columnElement = document.createElement('div');
            columnElement.classList.add('column');
            columnElement.setAttribute('data-name', name);

            const labelElement = document.createElement('div');
            labelElement.classList.add('column-label', 'text-soft', 'margin-bottom-sm');
            labelElement.textContent = label;

            const contentElement = document.createElement('div');
            contentElement.classList.add('column-content', 'margin-bottom');

            const columnInternalElement = document.createElement('div');
            columnInternalElement.append(labelElement, contentElement);

            columnElement.append(columnInternalElement);

            $filtersRow.append(columnElement);

            const $column = $filtersRow.find(`> .column[data-name="${name}"]`);
            const $columnContent = $column.find('.column-content');

            const model = this.seed.clone();
            model.name = 'LayoutManager';

            const defaultAttributes = {};

            if (name === 'name') {
                defaultAttributes.link = true;
            }

            const attr = (this.model.get('columnsData') || {})[name] || defaultAttributes;
            model.set(attr);

            this.fieldDataList.forEach(item => {
                const fieldHtml =
                    '<div class="column-field" data-name="' + item.name + '">' +
                        '<label class="control-label small">' +
                            this.translate(item.name, 'layoutFields', 'Report') +
                        '</label>' +
                        '<div class="field-content"></div>' +
                    '</div>';

                const $field = $(fieldHtml);

                $columnContent.append($field);

                this.createView(`field-${name}-${item.name}`, item.view, {
                    model: model,
                    name: item.name,
                    defs: {
                        name: item.name,
                        params: item.params || {},
                    },
                    selector: `.column[data-name="${name}"] .column-content .column-field[data-name="${item.name}"] ` +
                        `.field-content`,
                    mode: 'edit',
                }, view => {
                    view.render();
                });
            });
        },

        fetch: function () {
            const data = {};

            this.columnList.forEach(name => {
                let columnData = {};

                this.fieldDataList.forEach(item => {
                    const view = this.getView(`field-${name}-${item.name}`);

                    if (!view) {
                        return;
                    }

                    columnData = _.extend(columnData, view.fetch());
                });

                data[name] = columnData;
            });

            return {'columnsData': data};
        },
    });
});
