/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

define('sales:views/invoice/record/detail', ['sales:views/quote/record/detail'], function (Dep) {

    return Dep.extend({

        actionComposeEmail: function () {
            Espo.Ui.notify(' ... ');

            this.createView('dialog', 'sales:views/invoice/modals/send-in-email', {model: this.model}, view => {
                view.render();
                Espo.Ui.notify(false);

                this.listenToOnce(view, 'apply', attributes => {
                    const viewName = this.getMetadata().get('clientDefs.Email.modalViews.compose') ||
                        'views/modals/compose-email';

                    this.createView('composeEmail', viewName, {
                        attributes: attributes,
                        keepAttachmentsOnSelectTemplate: true,
                        appendSignature: true,
                    }, view => {
                        view.render();

                        Espo.Ui.notify(false);
                    });
                });
            });
        },
    });
});
