<?php

namespace Espo\Modules\EblaForm\Core\Utils;

use Espo\Core\Di\ConfigAware;
use Espo\Core\Di\ConfigSetter;
use Espo\Core\Di\EntityManagerAware;
use Espo\Core\Di\EntityManagerSetter;
use Espo\Core\Utils\Client\RenderParams;
use Espo\Core\Utils\ClientManager;

class EblaFormClientManager extends ClientManager implements EntityManagerAware, ConfigAware
{
    private string $runScript = 'app.start();';
    use EntityManagerSetter;
    use ConfigSetter;
    /**
     * Render.
     *
     * @param RenderParams $params Parameters.
     */

    public function render(?RenderParams $params = null, ?string $htmlFilePath = null, array $vars = []): string
    {
        // Overriding the html file path
        $htmlFilePath2 = 'client/custom/modules/ebla-form/html/ebla-form.html';
        return parent::render($params, $htmlFilePath2, $vars);
    }

    public function display(?string $runScript = null, ?string $htmlFilePath = null, array $vars = []): void
    {
        $eblaFormId = Url::detectEblaFormId();
        $eblaForm = $this->entityManager->getEntityById('EblaForm', $eblaFormId);

        if (!$eblaForm) {
            exit('<center>Not Exist.</center>');
        }

        if (!$eblaForm->get('isActive')) {
            exit('<center>Not Active.</center>');
        }

        $runScript = $runScript ?? "app.startEblaForm('{$eblaFormId}');";

        $src = $this->getBasePath() . 'client/custom/modules/ebla-form/css/ebla-form.css' . '?r=' . $this->getCacheTimestamp();
        $vars['eblaFormStyleSheetsHtml'] = "\n        <link rel=\"stylesheet\" href=\"{$src}\">";
        $vars['applicationId'] = 'espocrm-ebla-form-application-' . $eblaFormId;
        $vars['customCSS'] = $eblaForm->get('customCSS');
        $vars['basePath'] = $this->getBasePath();
        $vars['applicationName'] = $eblaForm->get('name');
        $vars['applicationDescription'] = $eblaForm->get('description') ?? $this->config->get('applicationDescription') ?? '';
        $vars['appClientClassName'] = 'ebla-form:app';
        $vars['useCache'] = 'false';
        $vars['backgroundColor'] = $eblaForm->get('isTransparent') ? '#00000000' : $eblaForm->get('backgroundColor') ?? '#FFF59D';
        $integration = $this->entityManager->getEntityById('Integration', 'ReCaptcha');

        if ($eblaForm->get('reCaptchaEnabled') && $integration && $integration->get('enabled')) {
            $vars['reCaptchaHtml'] = '<script src="https://www.google.com/recaptcha/api.js?render=explicit" nonce="{{nonce}}"></script>';
        } else {
            $vars['reCaptchaHtml'] = '';
        }
        $htmlFilePath = $htmlFilePath ??'client/custom/modules/ebla-form/html/ebla-form.html';
        parent::display($runScript, $htmlFilePath, $vars);
    }

    private function getCacheTimestamp(): int
    {
        if (!$this->useCache()) {
            return time();
        }

        return $this->config->get('cacheTimestamp', 0);
    }

    private function useCache(): bool
    {
        return (bool)$this->config->get('useCache');
    }
}
