<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

namespace Espo\Modules\Sales\Classes\Select\Product\PrimaryFilters;

use Espo\Core\Select\Primary\Filter;
use Espo\Modules\Sales\Entities\Product;
use Espo\ORM\Query\SelectBuilder as QueryBuilder;

class AllVariants implements Filter
{
    public const NAME = 'allVariants';

    public function apply(QueryBuilder $queryBuilder): void
    {
        $queryBuilder
            ->where(['type' => Product::TYPE_VARIANT]);
    }
}
